﻿var syncPanelHistory = {
    context: $(".v-synchronizePanelDataHistory"),
    datatable: undefined,
    autocomplete: undefined,
    initialize: function () {
        this.datatable = $(".h-synchronizePanelDataHistory", this.context).a4datatable({
            customStyle: "compact",
            ajaxAction: a4.getSurveyAction("GetSynchronizePanelDataHistory", "Analyze"),
            displaySearchBox: false,
            allowRowSelection: true,
            defaultSorting: { Column: "ExecutionDateTime", Ascending: false },
            columns: [
                { "Data": "ErrorMessage", "Tooltip": true, "DisplayCondition": function (data) { return data.Status == 'Failed'; } },
                { "Name": "Status", "Title": resources.Status, "Data": "StatusEnum" },
                { "Name": "UserName", "Title": resources.UserId, "Data": "UserName" },
                { "Name": "ExecutionDateTime", "Title": resources.DateTime, "Data": "ExecutionDateTime" }
            ],
            contextMenuItems: [{ "Action": "details", "Label": resources.ViewDetails, "DisplayCondition": function (data) { return data.Status == 'Completed'; } }],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "details") {
                    modalDialog.showWindow(a4.getSurveyAction("ViewSynchronizePanelDataHistoryDetails", "Analyze", { taskId: +row.TaskId }), 500, 800, {
                        afterClose: function () { }
                    });
                }
            }
        });
    },
    bindEvents: function () { }
}

$(document).ready(function () {
    if (syncPanelHistory.context.length > 0) {
        syncPanelHistory.initialize();
        syncPanelHistory.bindEvents();
    }
});